@extends('layouts.table-page')

@section('title',$title)

@section('header', $title)

@section('header-text')
Listado general de remotas satelitales.
@endsection

@section('header-actions')
@can('remotas_satelital.create')
<a class="btn btn-primary align-self-end mb-4" href="{{ route('remotas.create') }}">Agregar</a>
@endcan
@endsection

@section('table-head')
<div class="table-responsive w-100">
    <table class="table datatable w-100 table-bordered">
        <thead>
            <tr>
                <th scope="col" class="text-center">#</th>
                <th scope=" col" class="text-center col-20">Equipo</th>
                <th scope=" col" class="text-center col-20">Cliente</th>
                <th scope=" col" class="text-center col-5 ">Estado</th>
                <th scope=" col" class="text-center d-none hidden-column">Serial antena</th>
                <th scope=" col" class="text-center col-10">Kit</th>
                <th scope=" col" class="text-center col-10">Dia Corte</th>
                <th scope=" col" class="text-center">Acciones</th>
            </tr>
        </thead>
    </table>
</div>
@endsection

@section('table-body')
@forelse($rows as $item)
<tr>
    <th class="text-center">{{ $item->id}}</th>
    <td class="text-left">@truncate($item->equipo)</td>
    <td class="text-left"> {{ $item->cliente->getClientName() }}</td>
    <td class="text-center "><span class="badge bg-{{ $item->estadoBadge }}">{{ $item->status
            }}</span></td>
    <td class="text-center d-none ">{{ $item->antena_serial }}</td>
    <td class="text-center d-none d-sm d-md-table-cell">{{ $item->kit_serial }}</td>
    <td class="text-center">{{ $item->fecha_corte }}</td>
    <td scope="col" class="text-center d-flex justify-content-center align-items-center h-100">
        {{-- Boton de acciones --}}
        <div class="dropdown">
            <button class=" btn btn-outline-primary btn-xs p-3 pt-1 pb-1 me-1" type="button" data-bs-toggle="dropdown"
                aria-expanded="false">
                <i class="fa-solid fa-bars"></i>
            </button>
            <ul class="dropdown-menu">
                @can('remotas_satelital.edit')
                <li><a class="dropdown-item" target="_blank" href="{{ route('remotas.edit', $item->uuid) }}"
                        title="Editar datos de la remoa">Editar</a></li>
                @endcan

                @can('remotas_satelital.show_detail')
                <li><a class="dropdown-item" target="_blank" href="{{ route('remotas.show', $item->id) }}">Full
                        Detalle</a></li>
                @endcan
                {{--


                @can('remotas_satelital.delete')
                <li>
                    <button class="dropdown-item" wire:click="confirmDelete('{{ $item->uuid }}')">Eliminar</button>
                </li>
                @endcan --}}

            </ul>
        </div>
        <!--

        <button type="button" class="btn btn-xs btn-info p-3 pt-1 pb-1 me-1" data-bs-toggle="modal"
            data-bs-target="#ver_remotas_{{  $item->uuid }}" title="Ver remotas">

            <i class="fa-regular fa-eye"></i>
        </button>
        @include('livewire.remota.includes.modales.show-detail', ['item' => $item])

        -->

    </td>
</tr>
@empty
<tr>
    <td colspan=" 5" class="text-center">No hay registros encontrados.</td>
</tr>
@endforelse
@endsection

@section('scripts')
<script>
    console.log('Página cargada con éxito.');
</script>
@endsection
